 ; Ŀ
 ;   Derot - Remove the rotation from an entity.                           
 ;   Also includes Drot, which does the same thing but ignores attributes. 
 ;                                                                         
 ;   Copyright 1990, 1997, 2003, 2004, 2006 By Rocket Software Ltd.        
 ;   Another program that seemed to need to be written.                    
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Drot - added program - derotate entities, ignore attributes.          
 ; 
 (defun C:DROT ( / un ss num lll lln typ ra)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (prompt "\nSelect entities to derotate: ")
  (setq ss (ssget))
  (setq num 0)
  (while (ssname ss 0)
         (setq lll (ssname ss 0))
         (setq lln (entget lll))
         (if (setq ra (assoc 50 lln))
             (progn
                  (setq num (1+ num))
                  (entmod (subst (cons 50 0) ra lln)))
             (setq un (if un (1+ un) 1)))
         (ssdel lll ss))
  (setq typ (strcat "Entities derotated: " (itoa num)))
  (prompt (if un (strcat typ ", untouched: " (itoa un)) typ))
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Derot.                                                                
 ; 
 (DEFUN C:DEROT (/ *error* osmo osmod ss num enam entt ra typ pa rotang
                                                                 asoc51 un)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk /)
   (if osmod (setvar "osmode" osmo))
  (princ))
 ; Ŀ
 ;   Turn off osnaps.                                                      
 ; 
  (if (zerop (logand (setq osmo (getvar "osmode")) 16384))
      (progn
           (setq osmod t)
           (setvar "osmode" (+ osmo 16384))))
  (prompt "\nSelect entities to derotate: ")
  (setq ss (ssget))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (if (setq ra (cdr (assoc 50 entt)))
             (progn
                  (setq typ (cdr (assoc 0 entt)))
                  (if (= typ "TEXT")
                      (setq pa (spit entt))
                      (setq pa (cdr (assoc 10 entt))))
                  (setq rotang (- (/ (* 180 ra) pi)))
                  (command ".rotate" enam "" pa rotang)
                  (if (member typ '("TEXT" "ATTDEF"))
                      (progn
                           (setq entt (entget enam))
                           (if (and (setq asoc51 (assoc 51 entt))
                                    (/= (cdr asoc51) 0))
                               (entmod (subst (cons 51 0) asoc51 entt))))))
             (setq un (if un (1+ un) 1))))
  (setq typ (strcat "Entities derotated: " (itoa num)))
  (prompt (if un (strcat typ ", untouched: " (itoa un)) typ))
  (if osmod (setvar "osmode" osmo))
  (command "undo" "end")
 (princ))

(prompt "C:DROT/C:DEROT")
(princ)
